-- Reload recipes and technologies
for i, player in ipairs(game.players) do
  player.force.reset_recipes()
  player.force.reset_technologies()
end

for index, force in pairs(game.forces) do
  -- Generate technology and recipe tables
  local tech = force.technologies
  local recipes = force.recipes

  -- Unlock researched recipes
  if tech["logistics"] and tech["logistics"].researched then
    if recipes["long-fast-inserter"] then
      recipes["long-fast-inserter"].enabled = true
    end
  end
  if tech["electronics"] and tech["electronics"].researched then
    if recipes["long-filter-inserter"] then
      recipes["long-filter-inserter"].enabled = true
    end
  end
  if tech["stack-inserter"] and tech["stack-inserter"].researched then
    if recipes["long-stack-inserter"] then
      recipes["long-stack-inserter"].enabled = true
    end
    if recipes["long-stack-filter-inserter"] then
      recipes["long-stack-filter-inserter"].enabled = true
    end
  end
end